<?php

// ACTIVTATION DU THEME ENFANT

function theme_enqueue_styles() {
 wp_enqueue_style( 'parent-style', get_template_directory_uri() . '/style.css' );
}
add_action( 'wp_enqueue_scripts', 'theme_enqueue_styles' );


// AJOUT DES ICONES FONT AWESOME

function load_fontawesome() {
  wp_enqueue_style( 'font-awesome', 'https://use.fontawesome.com/releases/v5.7.2/css/all.css', null, '5.7.2' );
}
add_action('wp_enqueue_scripts', 'load_fontawesome');

//ajouter une nouvelle zone de menu à mon thème
function register_my_menu() {
  register_nav_menu('menu-sticky',__( 'Menu sticky' ));
}
add_action( 'init', 'register_my_menu' );

//menu fixe à droite présent sur desktop et tablettes (pas sur mobile)
add_action('wp_footer', 'fixed_menu_contact'); 

function fixed_menu_contact() { 

$et_secondary_nav_items = et_divi_get_top_nav_items();

$et_phone_number = $et_secondary_nav_items->phone_number;

$et_email = $et_secondary_nav_items->email;

    echo '<div id="fixed-menu-contact-container">';
    echo '<a id="bloc-tel">';
    echo et_core_esc_previously( et_sanitize_html_input_text( $et_phone_number ));
    echo'</a>';
    echo '<a id="bloc-mail" href="mailto:';
    echo esc_html( $et_email );
    echo '">';
    echo esc_html( $et_email );
    echo '</a>';
//echo '<a id="bloc-tel" href="tel:+33142803839">0142803839</a>';
//echo '<a id="bloc-mail" href="mailto:info@ibssc.com">info@ibssc.com</a>';
    echo '</div>';
    echo '<div id="sticky-menu-container">';
    if ( has_nav_menu( 'menu-sticky' ) ) : wp_nav_menu ( array ('theme_location' => 'menu-sticky' , 'menu_class' => 'my-menu-sticky',) ); endif;
      echo '</div>';       
}


function create_post_type() {
  register_post_type( 'formations',
    array(
      'labels' => array(
        'name' => __( 'Formations' ),
        'singular_name' => __( 'Formation' )
      ),
      'public' => true,
      'has_archive' => true,
    )
  );
}
add_action( 'init', 'create_post_type', 0 );

if ( function_exists( "add_theme_support" ) ) { 
  add_theme_support( "post-thumbnails" );
}

 
function create_taxonomies() {

 
  $labels = array(
    'name' => _x( 'Editeurs', 'taxonomy general name' ),
    'singular_name' => _x( 'Editeur', 'taxonomy singular name' ),
    'search_items' =>  __( 'Search Editeurs' ),
    'all_items' => __( 'All Editeurs' ),
    'parent_item' => __( 'Parent Editeur' ),
    'parent_item_colon' => __( 'Parent Editeur:' ),
    'edit_item' => __( 'Edit Editeur' ), 
    'update_item' => __( 'Update Editeur' ),
    'add_new_item' => __( 'Add New Editeur' ),
    'new_item_name' => __( 'New Editeur Name' ),
    'menu_name' => __( 'Editeurs' ),
  );    
 
  register_taxonomy('editeurs',array('formations'), array(
    'hierarchical' => true,
    'labels' => $labels,
    'show_ui' => true,
    'show_admin_column' => true,
    'query_var' => true,
    'rewrite' => array( 'slug' => 'editeur' ),
  ));

    $labels = array(
    'name' => _x( 'Format', 'taxonomy general name' ),
    'singular_name' => _x( 'Format', 'taxonomy singular name' ),
    'search_items' =>  __( 'Search Formats' ),
    'all_items' => __( 'All Formats' ),
    'parent_item' => __( 'Parent Format' ),
    'parent_item_colon' => __( 'Parent Format:' ),
    'edit_item' => __( 'Edit Format' ), 
    'update_item' => __( 'Update Format' ),
    'add_new_item' => __( 'Add New Format' ),
    'new_item_name' => __( 'New Format Name' ),
    'menu_name' => __( 'Formats' ),
  );    
 
  register_taxonomy('formats',array('formations'), array(
    'hierarchical' => true,
    'labels' => $labels,
    'show_ui' => true,
    'show_admin_column' => true,
    'query_var' => true,
    'rewrite' => array( 'slug' => 'format' ),
  ));
 
}
add_action( 'init', 'create_taxonomies', 1 );

// REMOVE WP EMOJI
remove_action('wp_head', 'print_emoji_detection_script', 7);
remove_action('wp_print_styles', 'print_emoji_styles');

remove_action( 'admin_print_scripts', 'print_emoji_detection_script' );
remove_action( 'admin_print_styles', 'print_emoji_styles' );


