<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.6
 */

$thumb_size = 'rdtheme-size8';
$args = array(
	'post_type'      => 'ac_testimonial',
	'posts_per_page' => $slider_item_number,
	'orderby' => $orderby,
	'order'   => $order,
);

if ( !empty( $cat ) ) {
	$args['tax_query'] = array(
		array(
			'taxonomy' => 'ac_testimonial_category',
			'field' => 'term_id',
			'terms' => $cat,
		)
	);
}

$query = new WP_Query( $args );

global $wp_query;
$wp_query = NULL;
$wp_query = $query;

$title_style       = $name_color ? "color:{$name_color};" : '';
$designation_style = $designation_color ? "color:{$designation_color};" : '';
$content_style     = $content_color ? "color:{$content_color};" : '';
?>
<div class="rt-vc-testimonial" style="padding: 3%;">
	<div class="owl-theme owl-carousel rt-owl-carousel" data-carousel-options='{"nav":true,"dots":true,"autoplay":true,"autoplayTimeout":"5000","autoplaySpeed":"200","autoplayHoverPause":true,"loop":true,"margin":30,"responsive":{"0":{"items":1},"480":{"items":1}}}'>
		<?php if ( have_posts() ): ?>
			<?php while ( have_posts() ) : the_post();?>
				<?php
				$id = get_the_ID();
				$designation = get_post_meta( $id, 'ac_testimonial_designation', true );
				$content = get_the_content();
				?>
				<div class="rt-item" style="max-width: 480px; margin-left:32%;">
					<div class="rt-item-img">
						<?php
						if ( has_post_thumbnail() ){
							the_post_thumbnail( $thumb_size ,  array( 'class' => 'img-circle' )  );
						}
						?>
					</div>
					<div class="rt-item-content-holder" style="background: #fff;padding: 5%;background-repeat:no-repeat;
    background-position: center bottom;background-image:url('http://ibs.digitalphaino.com/wp-content/uploads/2023/07/Logobgh4.png') !important; text-align: center;">
					<h3 style="color: #F08262;margin-top: 15%;">Votre avis nous est précieux</h3>
						
						<?php if( !empty( $designation ) ): ?>
							<span class="rt-item-designation" style="<?php echo esc_attr( $designation_style );?>"><?php echo esc_html( $designation ); ?></span>
						<?php endif; ?>			
						<p  style="padding: 5%;" ><?php echo esc_html( $content ); ?></p>
						<h4 style="<?php echo esc_attr( $title_style );?>"><?php the_title(); ?></h4>
					</div>
				</div>
			<?php endwhile; ?>
		<?php else:?>
			<?php esc_html_e( 'No Testimonial Found' , 'eikra-core' ); ?>
		<?php endif; ?>
		<?php wp_reset_query();?>
	</div>
</div>