<?php

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Module Name: Checkout Coupon
 * Description: 
 */
class TB_Checkout_Coupon_Module extends Themify_Builder_Component_Module {

	public static function init():void{
	}

	public static function is_available():bool{
		return themify_is_woocommerce_active();
	}

	public static function get_module_name():string {
		return __('Checkout Coupon', 'tbp');
	}

	public static function get_module_icon():string {
		return 'shopping-cart';
	}

	public static function get_js_css():array{
		return array(
			'ver' => TBP_VER,
			'css' => TBP_WC_CSS_MODULES . 'checkout-coupon'
		);
	}

	/**
	 * Render plain content for static content.
	 */
	public static function get_static_content(array $module):string {
		return '';
	}

    public static function get_styling_image_fields() : array {
        return [];
    }

    public static function render_form() {
        echo self::retrieve_template( 'wc/checkout/coupon.php', [] );
    }
}