<?php
/**
 * Template Cross-sell Products
 * 
 * Access original fields: $args['mod_settings']
 * @author Themify
 */

if ( ! defined('ABSPATH') || !themify_is_woocommerce_active() || is_checkout() ) {
	return;
}

global $product;
$mod_name = $args['mod_name'];
$element_id = $args['module_ID'];
$fields_args = $args['mod_settings']+ array(
	'title_tag' => 'h2',
	'heading' => '',
	'layout' => 'grid3',
	'limit' => 2,
	'css' => '',
	'animation_effect' => ''
);
$container_class = apply_filters('themify_builder_module_classes', array(
	'module',
	'module-' . $mod_name,
	$element_id,
	$fields_args['css']
	), $mod_name, $element_id, $fields_args);

if (!empty($fields_args['global_styles']) && Themify_Builder::$frontedit_active === false && Tbp_Utils::$isActive===false) {
	$container_class[] = $fields_args['global_styles'];
}
$container_props = apply_filters('themify_builder_module_container_props', self::parse_animation_effect($fields_args, array(
		'class' => implode(' ', $container_class),
	)), $fields_args, $mod_name, $element_id);

if (Themify_Builder::$frontedit_active === false) {
	$container_props['data-lazy'] = 1;
}
?>
<!-- Cross-sell Products module -->
<div <?php echo themify_get_element_attributes(self::sticky_element_props($container_props, $fields_args)); ?>>
	<?php
	$container_props = $container_class = $args = null;

    $cross_sells = array_filter( array_map( 'wc_get_product', WC()->cart->get_cross_sells() ), 'wc_products_array_filter_visible' );
    if ( empty( $cross_sells ) ) {
        echo '</div>';
        return;
    }

    $col = (int) ltrim( $fields_args['layout'], 'grid' );
    wc_set_loop_prop( 'name', 'cross-sells' );
    wc_set_loop_prop( 'columns', apply_filters( 'woocommerce_cross_sells_columns', $col ) );

    // Handle orderby and limit results.
    $orderby     = apply_filters( 'woocommerce_cross_sells_orderby', 'rand' );
    $order       = apply_filters( 'woocommerce_cross_sells_order', 'desc' );
    $cross_sells = wc_products_array_orderby( $cross_sells, $orderby, $order );
    $cross_sells = $fields_args['limit'] > 0 ? array_slice( $cross_sells, 0, $fields_args['limit'] ) : $cross_sells;

    echo self::retrieve_template( 'wc/cart/cross-sells.php', $fields_args + [
        'col' => $col,
        'cross_sells' => $cross_sells
    ], __DIR__ ); ?>

</div><!-- /Cross-sell Products module -->