<?php
/**
 * A single course loop rating
 *
 * @package Tutor\Templates
 * @subpackage CourseLoopPart
 * @author Themeum <support@themeum.com>
 * @link https://themeum.com
 * @since 1.4.3
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$class               = isset( $class ) ? ' ' . $class : ' tutor-mb-8';
$show_course_ratings = apply_filters( 'tutor_show_course_ratings', true, get_the_ID() );
$coach_id = get_the_ID();

$string2             =  get_the_content() ;
$words = explode(" ", $string2);

// On prend seulement les 10 premiers
$first10 = array_slice($words, 0, 10);

// On reconstruit la phrase
$intro= implode(" ", $first10);

?>

<div class="tutor-course-ratings<?php echo esc_html( $class ); ?>">

	<?php if ( $show_course_ratings ) : ?>
	<div class="tutor-ratings">
		<div class="tutor-ratings-stars">
		<?php echo do_shortcode('[site_reviews_summary assigned_posts="' . esc_attr($coach_id) . '"]'); //echo $coach_id." ggdsyu";?>
			<div class="txtcoachlist"><?php echo $intro;  ?></div>
		</div>

		
	</div>
	<?php endif; ?>
</div>
<?php do_action( 'tutor_after_course_loop_rating', get_the_ID() ); ?>
