document.addEventListener("DOMContentLoaded", function () {
    const dateInputs = document.querySelectorAll('input.flatpickr-input'); // Select Flatpickr input fields
    const today = new Date(); // Get today's date
    const maxDate = today.getFullYear() + "-" + String(today.getMonth() + 1).padStart(2, '0') + "-" + String(today.getDate()).padStart(2, '0'); // Format as YYYY-MM-DD

    dateInputs.forEach(input => {
        // Destroy any existing Flatpickr instance (to avoid conflicts)
        if (input._flatpickr) {
            input._flatpickr.destroy();
        }

        // Reinitialize Flatpickr with correct configuration
        flatpickr(input, {
            maxDate: maxDate, // Restrict dates to today or earlier
            dateFormat: "d/m/Y", // Display date in DD/MM/YYYY format
        });
    });
});
