/*  jQuery Nice Select - v1.1.0
    https://github.com/hernansartorio/jquery-nice-select
    Made by Hernán Sartorio  */
 
(function($) {

  $.fn.niceSelect = function(method) {
    
    // Methods
    if (typeof method == 'string') {      
      if (method == 'update') {
        this.each(function() {
          var $select = $(this);
          var $dropdown = $(this).next('.analytify_nice-select');
          var open = $dropdown.hasClass('.analytify_open');
          
          if ($dropdown.length) {
            $dropdown.remove();
            create_nice_select($select);
            
            if (open) {
              $select.next().trigger('click');
            }
          }
        });
      } else if (method == 'destroy') {
        this.each(function() {
          var $select = $(this);
          var $dropdown = $(this).next('.analytify_nice-select');
          
          if ($dropdown.length) {
            $dropdown.remove();
            $select.css('display', '');
          }
        });
        if ($('.analytify_nice-select').length == 0) {
          $(document).off('.analytify_nice-select');
        }
      } else {
        console.log('Method "' + method + '" does not exist.')
      }
      return this;
    }
      
    // Hide native select
    this.hide();
    
    // Create custom markup
    this.each(function() {
      var $select = $(this);
      
      if (!$select.next().hasClass('analytify_nice-select')) {
        create_nice_select($select);
      }
    });
    
    function create_nice_select($select) {
      $select.after($('<div></div>')
        .addClass('analytify_nice-select')
        .addClass($select.attr('class') || '')
        .addClass($select.attr('disabled') ? 'disabled' : '')
        .attr('tabindex', $select.attr('disabled') ? null : '0')
        .html('<span class="analytify_current"></span><ul class="analytify_list"></ul>')
      );
        
      var $dropdown = $select.next();
      var $options = $select.find('option');
      var $selected = $select.find('option:selected');
      
      $dropdown.find('.analytify_current').html($selected.data('analytify_display') || $selected.text());
      
      $options.each(function(i) {
        var $option = $(this);
        var display = $option.data('display');

        $dropdown.find('ul').append($('<li></li>')
          .attr('data-value', $option.html())
          .attr('data-display', (display || null))
          .addClass('analytify_option' +
            ($option.is(':selected') ? ' selected' : '') +
            ($option.is(':disabled') ? ' disabled' : ''))
          .html($option.text())
        );
      });
    }
    
    /* Event listeners */
    
    // Unbind existing events in case that the plugin has been initialized before
    $(document).off('.analytify_nice_select');
    
    // Open/close
    $(document).on('click.analytify_nice_select', '.analytify_nice-select', function(event) {
      var $dropdown = $(this);
      
      $('.analytify_nice-select').not($dropdown).removeClass('analytify_open');
      $dropdown.toggleClass('analytify_open');
      
      if ($dropdown.hasClass('analytify_open')) {
        $dropdown.find('.analytify_option');  
        $dropdown.find('.analytify_focus').removeClass('analytify_focus');
        $dropdown.find('.analytify_selected').addClass('analytify_focus');
      } else {
        $dropdown.focus();
      }
    });
    
    // Close when clicking outside
    $(document).on('click.analytify_nice_select', function(event) {
      if ($(event.target).closest('.analytify_nice-select').length === 0) {
        $('.analytify_nice-select').removeClass('analytify_open').find('.analytify_option');  
      }
    });
    
    // Option click
    $(document).on('click.analytify_nice_select', '.analytify_nice-select .analytify_option:not(.analytify_disabled)', function(event) {
      var $option = $(this);
      var $dropdown = $option.closest('.analytify_nice-select');
      
      $dropdown.find('.analytify_selected').removeClass('analytify_selected');
      $option.addClass('analytify_selected');
      
      var text = $option.data('analytify_display') || $option.text();
      $dropdown.find('.analytify_current').text(text);
      
      $dropdown.prev('select').val($option.data('value')).trigger('change');
    });

    // Keyboard events
    $(document).on('keydown.analytify_nice_select', '.analytify_nice-select', function(event) {    
      var $dropdown = $(this);
      var $focused_option = $($dropdown.find('.analytify_focus') || $dropdown.find('.analytify_list .analytify_option.analytify_selected'));
      
      // Space or Enter
      if (event.keyCode == 32 || event.keyCode == 13) {
        if ($dropdown.hasClass('analytify_open')) {
          $focused_option.trigger('click');
        } else {
          $dropdown.trigger('click');
        }
        return false;
      // Down
      } else if (event.keyCode == 40) {
        if (!$dropdown.hasClass('analytify_open')) {
          $dropdown.trigger('click');
        } else {
          var $next = $focused_option.nextAll('.analytify_option:not(.analytify_disabled)').first();
          if ($next.length > 0) {
            $dropdown.find('.analytify_focus').removeClass('analytify_focus');
            $next.addClass('analytify_focus');
          }
        }
        return false;
      // Up
      } else if (event.keyCode == 38) {
        if (!$dropdown.hasClass('analytify_open')) {
          $dropdown.trigger('click');
        } else {
          var $prev = $focused_option.prevAll('.analytify_option:not(.analytify_disabled)').first();
          if ($prev.length > 0) {
            $dropdown.find('.analytify_focus').removeClass('analytify_focus');
            $prev.addClass('analytify_focus');
          }
        }
        return false;
      // Esc
      } else if (event.keyCode == 27) {
        if ($dropdown.hasClass('analytify_open')) {
          $dropdown.trigger('click');
        }
      // Tab
      } else if (event.keyCode == 9) {
        if ($dropdown.hasClass('analytify_open')) {
          return false;
        }
      }
    });

    // Detect CSS pointer-events support, for IE <= 10. From Modernizr.
    var style = document.createElement('a').style;
    style.cssText = 'pointer-events:auto';
    if (style.pointerEvents !== 'auto') {
      $('html').addClass('no-csspointerevents');
    }
    
    return this;

  };

}(jQuery));